<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vbsignatures');
define('IN_VBSIGNATURES', true);

if ($_REQUEST['do'] == 'ajax')
{
	define('CSRF_PROTECTION', true);
	define('LOCATION_BYPASS', 1);
	define('NOPMPOPUP', 1);
	define('VB_ENTRY', 'ajax.php');
	define('VB_ENTRY_TIME', microtime(true));
}

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('dbtech_vbsignatures', 'user', 'album');

// get templates used by all actions
$globaltemplates = array(
	'dbtech_vbsignatures',
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'main' => array(
		'dbtech_vbsignatures_inventory',
		'dbtech_vbsignatures_tabs',
		'dbtech_vbsignatures_tabbit',
		'dbtech_vbsignatures_tabcontent',
		'dbtech_vbsignatures_partbit',
	),
	'inventory' => array(
		'dbtech_vbsignatures_inventory',
		'dbtech_vbsignatures_tabs',
		'dbtech_vbsignatures_tabbit',
		'dbtech_vbsignatures_tabcontent',
		'dbtech_vbsignatures_partbit',
		'dbtech_vbsignatures_regionbit',
	),
	'shop' => array(
		'dbtech_vbsignatures_shop',
		'dbtech_vbsignatures_tabs',
		'dbtech_vbsignatures_tabbit',
		'dbtech_vbsignatures_tabcontent',
		'dbtech_vbsignatures_partbit_shop',
		'dbtech_vbsignatures_regionbit',
	),
);

// get special data templates from the datastore
require_once('./dbtech/vbsignatures/includes/specialtemplates.php');
$specialtemplates = $extracache;

// ############################### default do value ######################
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = $_GET['do'] = 'main';
}

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

if (!class_exists('vB_Template'))
{
	// Ensure we have this
	require_once(DIR . '/dbtech/vbsignatures/includes/class_template.php');
}

if (!class_exists('VBSIGNATURES'))
{
	eval(standard_error($vbphrase['dbtech_vbsignatures_deactivated']));
}

if ($_REQUEST['do'] == 'devinfo' AND $_REQUEST['devkey'] == 'dbtech')
{
	$_info = array(
		'version' 		=> VBSIGNATURES::$version,
		'versionnumber' => VBSIGNATURES::$versionnumber,
		'pro'			=> VBSIGNATURES::$isPro,
		'vbversion'		=> $vbulletin->versionnumber
	);
	$_content = array();
	foreach ($_info as $key => $val)
	{
		$_content[] = '"' . $key . '":"' . $val . '"';
	}
	echo '{' . implode(',', $_content) . '}';
	die();
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (!empty($_POST['do']))
{
	// $_POST requests take priority
	$action = $_POST['do'];
}
else if (!empty($_GET['do']))
{
	// We had a GET request instead
	$action = $_GET['do'];
}
else
{
	// No request
	$action = 'main';
}

// Strip non-valid characters
$action = preg_replace('/[^\w-]/i', '', $action);

if (!$vbulletin->options['dbtech_vbsignatures_active'])
{
	// Sb is shut off
	eval(standard_error($vbulletin->options['dbtech_vbsignatures_closedreason']));
}

if (!VBSIGNATURES::$permissions['canview'])
{
	// Can't view Activity
	print_no_permission();
}

// begin navbits
$navbits = array('vbsignatures.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['dbtech_vbsignatures_vbsignatures']);

// Core page template
$page_template = 'dbtech_vbsignatures';

// Show branding or not
$show['vbsignatures_branding'] = $vbulletin->options['dbtech_vbsignatures_branding_free'] != '<(-=vBSignatures.Key.Branding.Free=-)>';

$signaturestyles = array(
	'shop' 		=> '',
	'inventory' => ''
);
if ($vbulletin->userinfo['userid'])
{
	foreach ((array)VBSIGNATURES::$cache['signaturestyle'] as $signaturestyleid => $signaturestyle)
	{
		if (!$signaturestyle['active'])
		{
			// Inactive style
			continue;
		}
		
		if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, $signaturestyle['permissions'], 'default'))
		{
			// Can't access style
			continue;
		}
		
		// Add to shop styles
		$signaturestyles['shop'] .= (intval($vbulletin->versionnumber) == 3 ? 
			'' : 
			'<li><a href="vbsignatures.php?' . $vbulletin->session->vars['sessionurl'] . 'do=shop&amp;signaturestyleid=' . $signaturestyle['signaturestyleid'] . '">' . $signaturestyle['title'] . '</a></li>'
		);
		
		// Add to inventory styles
		$signaturestyles['inventory'] .= (intval($vbulletin->versionnumber) == 3 ? 
			'' : 
			'<li><a href="vbsignatures.php?' . $vbulletin->session->vars['sessionurl'] . 'do=inventory&amp;signaturestyleid=' . $signaturestyle['signaturestyleid'] . '">' . $signaturestyle['title'] . '</a></li>'
		);
	}
}

if (!file_exists(DIR . '/dbtech/vbsignatures/actions/' . $action . '.php'))
{
	if (!file_exists(DIR . '/dbtech/vbsignatures_pro/actions/' . $action . '.php'))
	{
		// Throw error from invalid action
		eval(standard_error(fetch_error('dbtech_vbsignatures_error_x', $vbphrase['dbtech_vbsignatures_invalid_action'])));
	}
	else
	{
		// Include the selected file
		include_once(DIR . '/dbtech/vbsignatures_pro/actions/' . $action . '.php');	
	}
}
else
{
	// Include the selected file
	include_once(DIR . '/dbtech/vbsignatures/actions/' . $action . '.php');	
}

// Apply some rounding and formatting
$vbulletin->userinfo['dbtech_vbsignatures_points'] = vb_number_format(floor($vbulletin->userinfo['dbtech_vbsignatures_points']));

if (intval($vbulletin->versionnumber) == 3)
{
	// Create navbits
	$navbits = construct_navbits($navbits);	
	eval('$navbar = "' . fetch_template('navbar') . '";');
}
else
{
	$navbar = render_navbar_template(construct_navbits($navbits));	
}

if (intval($vbulletin->versionnumber) == 3)
{
	// Begin the monster template
	$headinclude .= vB_Template::create('dbtech_vbsignatures.css')->render();
}

// Show branding or not
$show['dbtech_vbsignatures_producttype'] = (VBSIGNATURES::$isPro ? ' (Pro)' : ' (Lite)');

// Finish the main template
$templater = vB_Template::create($page_template);
	$templater->register_page_templates();
	$templater->register('navclass', 		$navclass);
	$templater->register('HTML', 			$HTML);
	$templater->register('navbar', 			$navbar);
	$templater->register('pagetitle', 		$pagetitle);
	$templater->register('pagedescription', $pagedescription);
	$templater->register('template_hook', 	$template_hook);
	$templater->register('includecss', 		$includecss);
	$templater->register('year',			date('Y'));
	$templater->register('jQueryVersion',	VBSIGNATURES::$jQueryVersion);
	$templater->register('version',			VBSIGNATURES::$version);
	$templater->register('versionnumber', 	VBSIGNATURES::$versionnumber);
	$templater->register('headinclude', 	$headinclude);
	$templater->register('styles', 			$signaturestyles);
	$templater->register('signaturestyleid',$signaturestyle['signaturestyleid']);
print_output($templater->render());

/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: vbsignatures.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>